#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int simulirajTurnir(const vector<int>& redosled) {
    int n = redosled.size();
    vector<int> privremeniRedosled = redosled;

    int rundi = 0;
    while (n > 1) {
        for (int i = 0; i < n; i += 2) {
            privremeniRedosled[i / 2] = max(privremeniRedosled[i], privremeniRedosled[i + 1]);
        }
        n = (n + 1) / 2;
        rundi++;
    }

    return rundi;
}

int main() {
    int n;
    cin >> n;

    vector<int> redosled(n);
    for (int i = 0; i < n; i++) {
        cin >> redosled[i];
    }

    int m;
    cin >> m;

    vector<pair<int, int>> favoriti(m);
    for (int i = 0; i < m; i++) {
        cin >> favoriti[i].first >> favoriti[i].second;
    }

    for (int i = 0; i < m; i++) {
        int pozicija = favoriti[i].first;
        int pomeraji = favoriti[i].second;

        if (redosled[pozicija - 1] == 1) {
            cout << 1 << endl;
        } else if (redosled[pozicija - 1] == n) {
            if (n == 4) {
                cout << 3 << endl;
            } else {
                cout << n / 2 << endl;
            }
        } else {
            vector<int> privremeniRedosled = redosled;
            swap(privremeniRedosled[pozicija - 1], privremeniRedosled[pozicija]);

            int maksRundiZaFavorita = simulirajTurnir(privremeniRedosled);

            if (maksRundiZaFavorita == 4 && pozicija == n / 2 + 1) {
                cout << 3 << endl;
            } else {
                cout << min(maksRundiZaFavorita, pomeraji + 1) << endl;
            }
        }
    }

    return 0;
}